<?php
//Use the Attestation Object Temporarily: 
// You can validate the attestation during registration but may not need to keep it afterward.

// Both clientDataJSON and authenticatorData should be in binary format (not JSON strings) when you combine them

// Function to authenticate a user using WebAuthn
function authUser($data)
{ global $db, $rpHost;
  $functionName = "authUser: ";
  logMessage($functionName ."start: rpHost: $rpHost");

  $credNo = $data['credNo']; 
  $userId = $data['userId']; 
  $challenge = $data['challenge'];
  $signature = $data['signature'];
  $clientDataJSON = $data['clientDataJSON'];
  $authData = $data['authenticatorData']; 

  $result = connect_database();
  
  if (!str_starts_with($result, 'ok'))
  {  mysqli_free_result($db);
     return json_encode(['status' => 'error','message' => $result]); 
  }   

  logMessage($functionName ."Signature:".PHP_EOL.$signature);
   
  try {
// check challenge	  
    logMessage($functionName .'check challenge');
	 
    $stmt = $db->prepare("select id, challenge, public_key from credentials ".
	                     "where credno = :credno and user_id = :user_id and rphost = :rphost");
   // Bind the parameter
    $stmt->bindParam(':credno', $credNo, PDO::PARAM_INT);
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
    $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
    $stmt->execute();
    
    if ($stmt->rowCount() === 0)
     { return json_encode(['status' => 'error','message' => $functionName . 'user_id ('.$userId.') not found']);}
		 
    // Fetch the result
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($challenge != base64_encode($data['challenge']))
    {   return json_encode(['status' => 'error','message' => 'invalid challenge.']);}	

    $publicKey = $data['public_key'];
  }
  catch (PDOException $e)
	{return json_encode(['status' => 'error','message' => 'Database error: ' . $e->getMessage()]);}   
  
  logMessage($functionName .'challenge ok');

  return authenticateSignature($userId, $clientDataJSON, $authData, $signature, $publicKey);
}    


function authenticateSignature($userId, $clientDataJSON, $authenticatorData, $signature, $publicKey) 
{ $functionName = "authenticateSignature: ";
  logMessage($functionName .'start: ' .$userId);

// Verify the signature using the stored public key
  $isValid = verifySignature($clientDataJSON, $authenticatorData, $signature, $publicKey);

  if ($isValid) {
      // Authentication successful
      return json_encode(['status' => 'success','message' => 'Authentication success']); 
  } else {
      // Authentication failed
      return json_encode(['status' => 'error','message' => 'ERROR: Authentication failed']);
  }
}


function verifySignature($clientDataJSON, $authenticatorData, $signature, $publicKey) {
// all field are base64
  $functionName = "verifySignature: ";
  logMessage($functionName .'start'.PHP_EOL);

  $publicKey_PEM = "-----BEGIN PUBLIC KEY-----\n" .
                 chunk_split($publicKey, 64, "\n") .
                 "-----END PUBLIC KEY-----\n";

  $clientDataBinary = base64url_decode($clientDataJSON);
  $authenticatorDataBinary = base64url_decode($authenticatorData);
  $clientDataHash = hash('sha256', $clientDataBinary, true);
  $dataToVerify = $authenticatorDataBinary . $clientDataHash;
  $signatureBinary = base64url_decode($signature);

// Verify the signature
  logMessage($functionName .'openssl_verify');
  $isValid = openssl_verify($dataToVerify, $signatureBinary, $publicKey_PEM, OPENSSL_ALGO_SHA256);
      
  if ($isValid !== 1)
  {	logMessage($functionName .'signature could be invalid');
    while ($msg = openssl_error_string()) {
      logMessage($functionName .'openssl_verify:'."$msg\n");}
  }	  
  else	  
    logMessage($functionName .'signature is valid');

  return $isValid === 1; // Returns true if valid, false otherwise
}

function base64url_decode($data) {
    // Add padding if necessary
    $remainder = strlen($data) % 4;
    if ($remainder) {
        $data .= str_repeat('=', 4 - $remainder);
    }
    // Decode Base64url to binary
    return base64_decode(strtr($data, '-_', '+/'));
}

?>
