<?php
/*
To assist in development messages are logged in the webAuthn.log file stored on the server
*/

  require ("webauthnUser.php");
  error_reporting(E_ERROR | E_PARSE );
  ini_set('display_errors', 1);

  $functionName = 'Start: ';
  logMessage("WEBAUTHN.PHP".PHP_EOL);

$host_name = "localhost"; // or your server name
$database = "your_database"; // your database name
$user_name = "your_username"; // your database username
$password = "your_password"; // your database password
  
  
  try { // make sure host is trusted
    $rpHost = getTrustedHost([]); //['example.com', 'auth.example.com']
  } catch (RuntimeException $e) {
    // Log or handle invalid host
    http_response_code(400);
    exit("Invalid host");
  }
  
  if ($_SERVER['REQUEST_METHOD'] === 'POST') 
	processJSON();
  else
  if ($_SERVER['REQUEST_METHOD'] === 'GET') 
	processGET();  
  else {
    // Handle other request methods
    http_response_code(405); // Method Not Allowed
    echo "error: Invalid request method";
  }

  $functionName = 'End: ';
  logMessage("WEBAUTHN.PHP".PHP_EOL);

///
function processGET()
{ header('Content-Type: text/plain');

  if (!isset($_GET['option']))  
  { echo "Error: option missing";
    return;
  }	
  
  $option =  $_GET['option'];
  
  if ($option == 'getChallenge') // and Challenge
	getChallenge();  
  else 
    echo "Error: Invalid option";
}

function getChallenge() // and Credential ID
{ global $aaguid, $userId, $rpHost, $credentialID, $functionName; 

  $functionName = 'getChallenge: ';
  logMessage("start");
 
  $filename = 'webauthn.log';  // remove log file
  if (file_exists($filename)) 
    unlink($filename); 

  $httpHost = $_SERVER['HTTP_HOST'] ?? null;
  $serverName = $_SERVER['SERVER_NAME'] ?? null;
  logMessage($httpHost .PHP_EOL. $serverName);

  $userId =  $_GET['userId'];
  $aaguid =  $_GET['aaguid']; // ties the request to the authenticator (eg TPM, USB key)
  	  
  echo json_encode(['challenge' => generateChallenge(),
      'credentialid' => getCredentialId()]);  	     
}   

function generateChallenge()
{ global $aaguid, $userId, $rpHost, $credentialID, $functionName; 

  $functionName = 'generateChallenge: ';
  logMessage("start: aaguid: $aaguid userId: $userId rpHost: $rpHost");
	
// Generate a random binary string
  $randomBytes = random_bytes(32);

  $result = saveChallenge($randomBytes);    
  logMessage("result: $result" );
  
  if ($result != 'ok')  
	return $result;  
	
// Encode the random bytes in Base64
  logMessage("end: ". base64_encode($randomBytes));
  return base64_encode($randomBytes); // send base64 readable
}

function saveChallenge($challenge)
{ global $db, $aaguid, $userId, $rpHost, $credentialID, $functionName;
// aaguid = unknown = no aaguid yet from browser
  $functionName = 'saveChallenge: ';

  logMessage("start: aaguid: $aaguid userId: $userId rpHost: $rpHost");

  $result = connect_database();
  
  if (!str_starts_with($result, 'ok'))
  { mysqli_free_result($db);
    return $result; 
  }   

  logMessage("database connected");
  
  try {
   // check if user exists in credentials table
	 $stmt = $db->prepare("select id, credential_id from credentials ".
	                      "where aaguid = :aaguid and user_id = :user_id and rphost = :rphost");
     $stmt->bindParam(':aaguid', $aaguid, PDO::PARAM_STR);
     $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
     $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
     $stmt->execute();
    
     $recordCount = $stmt->rowCount();
	 
     if ($recordCount === 0)
	 { $stmt = $db->prepare("INSERT INTO credentials (user_id, rphost, challenge) ".
	                                         "VALUES (:user_id, :rphost, :challenge)");
       $stmt->bindParam(':challenge', $challenge);
       $stmt->bindParam(':user_id', $userId);
       $stmt->bindParam(':rphost', $rpHost);
	   // aaguid defaults to unknown
	   $credentialID = 'CID missing'; // doesnt exist yet
	 }	 
     else
    // Fetch the result
    { $data = $stmt->fetch(PDO::FETCH_ASSOC);
	  
      if (!$data)  // update credentials with challenge
      { $emess = 'problem reading challenge';
        logMessage($emess);
        return emess;
	  }
	  
	  $id = $data['id'];	// from select above
	  $credentialID = $data['credential_id'];
	  
	  if ($aaguid == "unknown") // will happen if there is an inplementation error
	  { $stmt = $db->prepare("DELETE from credentials where id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();	
        $credentialID = 'CID missing'; // doesnt exist  any more
		
        logMessage("Erroneous Challenge deleted");	 
        return 'ok';		  
	  }
	  
      $stmt = $db->prepare("update credentials set challenge = :challenge, ".
		                     " updated_at = NOW() where id = :id;");
	  
	  $stmt->bindParam(':id', $id, PDO::PARAM_INT);
      $stmt->bindParam(':challenge', $challenge);
	}
		 
    // Execute the insert or update statement
     if (!$stmt->execute()) 
     { $error = $stmt->errorInfo();
        //echo "SQLSTATE: " . $error[0] . "\n";
        // echo "Error Code: " . $error[1] . "\n";
       logMessage($error[2]); // readable message
       return "error: ". $error[2];
	 }; 
	 
     logMessage("Challenge Saved");	 
     return 'ok';
  } 
	
  catch (PDOException $e)
	{ $error = 'Database error: '.$e->getMessage();
	  logMessage($error);
      return "error: " . $e->getMessage();}    
} 		

function removeChallenge($data) 
{ global $db, $rpHost, $functionName;
  $functionName = "removeChallenge: ";
  
  logMessage("start: rpHost: $rpHost");

//  $aaguid = "unknown"
  $userId = $data['userId']; 
  $challenge = base64_decode($data['challenge']);

  $result = connect_database();
  
  if (!str_starts_with($result, 'ok'))
  {  mysqli_free_result($db);
     return json_encode(['status' => 'error','message' => $result]); 
  }   
  
  logMessage("database connected");

  try {
     $stmt = $db->prepare("DELETE from credentials ".
	                      "where aaguid = 'unknown' and challenge = :challenge and user_id = :user_id and rphost = :rphost");
     $stmt->bindParam(':challenge', $challenge, PDO::PARAM_STR);
     $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
     $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
     $stmt->execute();	

     $stmt = $db->prepare("DELETE from credentials ".
	                      "where aaguid = 'unknown' and user_id = :user_id and rphost = :rphost and credential_id = '' ");
     $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
     $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
     $stmt->execute();	

     logMessage("Challenge deleted");
	 return json_encode(['status' => 'success', 'message' => 'Challenge deleted.']); 				 
  } 	
  catch (PDOException $e)
	{ logMessage('Database error: ' . $e->getMessage());
	  return json_encode(['status' => 'error','message' => $e->getMessage()]);}   
} 		


function getCredentialId()
{ // dont need function but enables logging $credentialID
  global $credentialID, $functionName; 
  $functionName = 'getCredentialId: ';

  logMessage($credentialID);
  return $credentialID; 
}

//---------------
function processJSON()
{ global $rpHost;
  header('Content-Type: application/json'); // Set the content type to JSON

// Get the JSON data from the request body
  $data = json_decode(file_get_contents('php://input'), true);

 // Check if the data was received correctly
  if ($data === null) {
   // Handle JSON decoding error
     echo json_encode(['status' => 'error', 'message' => 'Invalid JSON']);
     exit;
  }

  // Process the data (for example, access $data['key'])
  // Here, you can perform any operations you need with the data
  
  if ($data['option'] === 'signature') 
    $response = authUser($data);
   else 
  if ($data['option'] === 'publicKey') 
    $response = savePublicKey($data);
  else
  if ($data['option'] === 'removechallenge') 
    $response = removeChallenge($data);
  else {
  // Handle other request methods
    http_response_code(405); // Method Not Allowed
    $response = json_encode(['status' => 'error', 'message' => 'Invalid request method']);
  }

// Send the JSON response
  echo $response; 
}  

// passkey registration, new credential record (created in save challenge)
function savePublicKey($data) 
{ global $db, $rpHost, $functionName;
  $functionName = "savePublicKey: ";
  logMessage("start: rpHost: $rpHost");

  $aaguid = $data['aaguid']; // will be a valid aaguid (not unknown)
  $userId = $data['userId']; 
  $challenge = base64_decode($data['challenge']);
  $credentialId = $data['credentialId']; 
  $clientDataJSON = base64_decode($data['clientDataJSON']);
  $public_key = $data['publicKey'];

// Validate clientDataJSON
  $clientData = json_decode($clientDataJSON, true);
  if ($clientData['type'] !== 'webauthn.create') {
    die(json_encode(['status' => 'error', 'message' => 'Invalid client data type.']));}

  $result = connect_database();
  
  if (!str_starts_with($result, 'ok'))
  {  mysqli_free_result($db);
     return json_encode(['status' => 'error','message' => $result]); 
  }   
  
  logMessage("database connected");

  try {
// check challenge	  
     $stmt = $db->prepare("select id, aaguid from credentials ".
	                      "where challenge = :challenge and user_id = :user_id and rphost = :rphost");
   // Bind the parameter
     $stmt->bindParam(':challenge', $challenge, PDO::PARAM_STR);
     $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
     $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
     $stmt->execute();

     if ($stmt->rowCount() === 0)
     { return json_encode(['status' => 'error','message' => 'challenge does not exist.']);}		 		
	 
     logMessage("Challenge found");

    // Fetch the result
     $data = $stmt->fetch(PDO::FETCH_ASSOC);
	 $challenge_aaguid = $data['aaguid'];
	 $id = $data['id'];
	 $challenge_id = $data['id'];
	 
	 logMessage("AAGUID: challenge: $challenge_aaguid - sent: $aaguid");
	 
     if ($challenge_aaguid == "unknown")
	 { // now check if there is already a record for the aaguid/userid/rpHost
       $stmt = $db->prepare("select id from credentials ".
	                      "where aaguid = :aaguid and user_id = :user_id and rphost = :rphost");
   // Bind the parameter
       $stmt->bindParam(':aaguid', $aaguid, PDO::PARAM_STR);
       $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
       $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
       $stmt->execute();

       if ($stmt->rowCount() === 1) // a record for the unknown aaguid exists 
	   { $data = $stmt->fetch(PDO::FETCH_ASSOC);
         $id = $data['id'];

	     // delete the challenge record 
	   	 $stmt = $db->prepare("DELETE from credentials where id = :id");
         $stmt->bindParam(':id', $challenge_id, PDO::PARAM_INT);
         $stmt->execute();	
	   }
	 }
	 
     // update credentials record - on registration signaturecount is reset to 0
     $stmt = $db->prepare(
		 "update credentials set aaguid = :aaguid, credential_id = :credential_id, ".
            "public_key = :public_key, signaturecount = 0, updated_at = NOW() where id = :id");
			
	 $stmt->bindParam(':id', $id, PDO::PARAM_INT);
     $stmt->bindParam(':aaguid', $aaguid);
     $stmt->bindParam(':credential_id', $credentialId);
     $stmt->bindParam(':public_key', $public_key);

    // Execute the statement
     if (!$stmt->execute()) 
     { logMessage("public key not saved");
 
       $error = $stmt->errorInfo();
       logMessage($error[2]); // readable message
       return json_encode(['status' => 'error', 
                 'message' => "Failed to register public key: ". $error[2]]);
	 }
	 
     logMessage("public key saved");
     return json_encode(['status' => 'success',
                'message' => 'Public key registered successfully.',
                'user_id' => $userId]); 				 
  } 	
  catch (PDOException $e)
	{ logMessage('Database error: ' . $e->getMessage());
	  return json_encode(['status' => 'error','message' => $e->getMessage()]);}   
} 		

// This code is designed to helps validate the host. eg prishprash.com
function getTrustedHost(array $allowedHosts = []): string {
    $httpHost = $_SERVER['HTTP_HOST'] ?? null;
    $serverName = $_SERVER['SERVER_NAME'] ?? null;
	
    $httpHost = normalizeHost($_SERVER['HTTP_HOST']);
    $serverName = normalizeHost($_SERVER['SERVER_NAME']);

    // Prefer HTTP_HOST but sanitize
    $host = $httpHost ?? $serverName ?? 'localhost';
    $host = preg_replace('/:\d+$/', '', $host);

    // Basic hostname validation
    if (!preg_match('/^[a-zA-Z0-9.-]+$/', $host)) {
        throw new RuntimeException("Invalid host format");
    }

    // Optional whitelist check
    if ($allowedHosts && !in_array($host, $allowedHosts, true)) {
        throw new RuntimeException("Host not allowed: $host");
    }

    // Sanity check: mismatch between HTTP_HOST and SERVER_NAME
    if ($httpHost && $serverName && $httpHost !== $serverName) {
//        error_log("Host mismatch: HTTP_HOST = $httpHost, SERVER_NAME = $serverName");
        // Optional: throw or log depending on your threat model
        throw new RuntimeException("Host mismatch: HTTP_HOST = $httpHost, SERVER_NAME = $serverName");
    }

    return $host;
}

function normalizeHost($host) {
    return preg_replace('/^www\./i', '', $host);
}

function connect_database()
{ global $db;
  global $host_name,$user_name,$password,$database;
  $functionName = "connect_database: ";

  try {
    $dsn = "mysql:host=$host_name;dbname=$database";
    $db = new PDO($dsn, $user_name, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
  } catch (PDOexception $err)
   { logMessageX($functionName.'Database error: ' . $e->getMessage());
     return 'error: '.$err->getMessage();}
  
  return 'ok';
}

function logMessage($data)
{ global $functionName;
  $filename = 'webauthn.log';
  $data = $functionName. $data;

// Use file_put_contents to write data to the file
  if (file_put_contents($filename, $data.PHP_EOL, FILE_APPEND | LOCK_EX) === false) {
    echo "Failed to write data to the file.";
  }
}

function logMessageX($data)
{
  $filename = 'webauthn.log';

// Use file_put_contents to write data to the file
  if (file_put_contents($filename, $data.PHP_EOL, FILE_APPEND | LOCK_EX) === false) {
    echo "Failed to write data to the file.";
  }
}

?>
 
