<?php
// Function to authenticate a user using WebAuthn
function authUser($data)
{ global $db, $rpHost, $functionName;
  $functionName = "authUser: ";
  logMessage("start: rpHost: $rpHost");

  $aaguid = $data['aaguid']; 
  $userId = $data['userId']; 
  $challenge = $data['challenge'];
  $signature = $data['signature'];
  $clientDataJSON = $data['clientDataJSON'];
  $authData = $data['authenticatorData']; 

  $result = connect_database();
  
  if (!str_starts_with($result, 'ok'))
  {  mysqli_free_result($db);
     return json_encode(['status' => 'error','message' => $result]); 
  }   

  logMessage("Signature:".PHP_EOL.$signature);
   
  try {
// check challenge	  
    logMessage('check challenge');
	 
    $stmt = $db->prepare("select id, challenge, public_key, signaturecount from credentials ".
	                     "where aaguid = :aaguid and user_id = :user_id and rphost = :rphost");
   // Bind the parameter
    $stmt->bindParam(':aaguid', $aaguid, PDO::PARAM_STR);
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_STR);
    $stmt->bindParam(':rphost', $rpHost, PDO::PARAM_STR);
    $stmt->execute();
    
    if ($stmt->rowCount() === 0)
     { return json_encode(['status' => 'error','message' => $functionName . 'user_id ('.$userId.') not found']);}
		 
    // Fetch the result
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($challenge != base64_encode($data['challenge']))
    {   return json_encode(['status' => 'error','message' => 'invalid challenge.']);}	

    if (!checkSignatureCount($data['id'], $authData, $data['signaturecount']))
    {   return json_encode(['status' => 'error','message' => 'Signature Count Invalid']);}	

    $publicKey = $data['public_key'];
  }
  catch (PDOException $e)
	{return json_encode(['status' => 'error','message' => 'Database error: ' . $e->getMessage()]);}   
  
  logMessage('challenge ok');

  return authenticateSignature($userId, $clientDataJSON, $authData, $signature, $publicKey);
}    

function authenticateSignature($userId, $clientDataJSON, $authenticatorData, $signature, $publicKey) 
{ global $functionName;
  $functionName = "authenticateSignature: ";
  logMessage('start: ' .$userId);

// Verify the signature using the stored public key
  $isValid = verifySignature($clientDataJSON, $authenticatorData, $signature, $publicKey);

  if ($isValid) {
      // Authentication successful
      return json_encode(['status' => 'success','message' => 'Authentication success']); 
  } else {
      // Authentication failed
      return json_encode(['status' => 'error','message' => 'ERROR: Authentication failed']);
  }
}

function verifySignature($clientDataJSON, $authenticatorData, $signature, $publicKey) 
{ global $functionName;
// all field are base64
  $functionName = "verifySignature: ";
  logMessage('start'.PHP_EOL);

  $publicKey_PEM = "-----BEGIN PUBLIC KEY-----\n" .
                 chunk_split($publicKey, 64, "\n") .
                 "-----END PUBLIC KEY-----\n";

  $clientDataBinary = base64url_decode($clientDataJSON);
  $authenticatorDataBinary = base64url_decode($authenticatorData);
  $clientDataHash = hash('sha256', $clientDataBinary, true);
  $dataToVerify = $authenticatorDataBinary . $clientDataHash;
  $signatureBinary = base64url_decode($signature);

// Verify the signature
  logMessage('openssl_verify');
  $isValid = openssl_verify($dataToVerify, $signatureBinary, $publicKey_PEM, OPENSSL_ALGO_SHA256);
      
  if ($isValid !== 1)
  {	logMessage('signature could be invalid');
    while ($msg = openssl_error_string()) {
      logMessage('openssl_verify:'."$msg\n");}
  }	  
  else	  
    logMessage('signature is valid');

  return $isValid === 1; // Returns true if valid, false otherwise
}

function base64url_decode($data) {
    // Add padding if necessary
    $remainder = strlen($data) % 4;
    if ($remainder) {
        $data .= str_repeat('=', 4 - $remainder);
    }
    // Decode Base64url to binary
    return base64_decode(strtr($data, '-_', '+/'));
}


// extra check to make sure signature is valid
function checkSignatureCount($id, $authData, $signaturecount)
{ global $db, $functionName;

  $functionName = "checkSignatureCount: ";
  $authenticatorData = base64url_decode($authData);

// Ensure it's at least 37 bytes long (32 RP ID hash + 1 flags + 4 signCount)
  if (strlen($authenticatorData) < 37) {
    logMessage("Authenticator data too short");
    return false;}

// Extract the 4-byte signature counter (bytes 33–36)
  $signCountBytes = substr($authenticatorData, 33, 4);
  $signCount = unpack("N", $signCountBytes)[1]; // Big-endian unsigned 32-bit

  if (($signCount + $signaturecount) == 0) { // some authentictors always return 0
    logMessage("Signature Count = 0");
    return true;}
 
  if ($signCount <= $signaturecount) {
    logMessage("Signature Count Error: signCount:". strval($signCount).' signaturecount: '. strval($signaturecount) );
    return false;}

  logMessage("signCount:". strval($signCount).' signaturecount: '. strval($signaturecount) );

  $stmt = $db->prepare("update credentials set signaturecount = :signCount where id = :id;");
  $stmt->bindParam(':id', $id, PDO::PARAM_INT);
  $stmt->bindParam(':signCount', $signCount);
  
  if (!$stmt->execute()) 
  { $error = $stmt->errorInfo();
    logMessage($error[2]); // readable message
    return false;
  }; 

  logMessage("signaturecount updated"); 
  return true;	  
}  
  
?>
